﻿<%@ Control Language="C#"%>
<%@ Import Namespace="Kesion.Cache" %>
<%@ Import Namespace="Kesion.BLL" %>
<%@ Import Namespace="System.Data" %>
<%@ Import Namespace="Kesion.Publics" %>
<%@ Import Namespace="Kesion.Components" %>

<script runat="server" type="text/C#">

    public string orderId = string.Empty;
    public string flag = string.Empty;
    public double realmoney = 0;        //入账金额，不含手续费
    public decimal vmoney = 0;          //实际需要支付金额   
    public decimal rate = 0;
    public int RateByUser = 0;
    public string OrderType = "0";
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 初始化
        orderId =Utils.ChkSQL(KSCMS.S("orderid"));
        flag = KSCMS.S("flag");
        OrderType = KSCMS.S("ordertype");
        if (string.IsNullOrEmpty(flag)) flag = KSCMS.S("from");
        
        if (string.IsNullOrEmpty(orderId))
        {
            orderId = Utils.RemoveXss(Utils.ChkSQL(KSCMS.S("payorderid")));
        }
        if (Context.Items["pay_orderid"] != null)  //在线充值卡购买
        {
            orderId = Context.Items["pay_orderid"].ToString();
        }
        if (string.IsNullOrEmpty(orderId))
        {
            KSCMS.Die("error!");
        }

        //手机访问，直接调用微信接口
        if (Utils.IsMobileDevice() == true)
        {
            Response.Redirect(MyCache.GetCacheConfig(5) + "/plus/pay/wx/send.aspx?orderid=" + orderId + "&OrderType=" + OrderType + "&flag=" + flag);
        }     

        string itemstr = string.Empty;

        //继续完成在线充值,已含手续费。

        #region 继续完成在线充值,已含手续费。

        using (DataTable dt = DataFactoryUser.GetDataTable("Select top 1 * From KS_RechargeRecords Where OrderID='" + orderId + "'"))
        {
            if (dt.Rows.Count <= 0)
            {
                JS.Alert("找不到该订单，无法支付!");
            }
            else
            {
                DataRow dr = dt.Rows[0];
                if (dr["status"].ToString() != "0")
                {
                    JS.Alert("该订单已支付过，不能再支付了!");
                }
                itemstr = dr["remark"].ToString();
                vmoney = Convert.ToDecimal(dr["realmoney"].ToString());

            }
        }
        #endregion

        realmoney = Convert.ToDouble(vmoney);  //实际入账金额,不含手续费
        if (RateByUser == 1)
        {
			vmoney = CutDecimalWithN((vmoney + vmoney * rate / 100),2);
        }
        else
        {
			vmoney = CutDecimalWithN(vmoney,2);
        }
        if (realmoney <= 0)
        {
            JS.AlertDoFun("支付金额必须大于0！", "history.back();");
        }
        else
        {
			realmoney = Convert.ToDouble( CutDecimalWithN(Utils.StrToDecimal(realmoney), 2));
        }
        #endregion

    }
    public float CopnumMoney(string copnum)
    {
        #region 计算优惠券
        string param = " select  sum(a.availablemoney) from KS_ProCouponUser a inner join KS_ProCoupon b on a.couponid=b.couponid Where useflag=0 and a.courseorder='" + copnum + "'";

        float fm = Utils.StrToFloat(DataFactory.GetOnlyValue(param));
        return fm;
        #endregion
    }
	public static decimal CutDecimalWithN(decimal d, int n)
	{
		string strDecimal = d.ToString();
		int index = strDecimal.IndexOf(".");
		if (index == -1 || strDecimal.Length < index + n + 1)
		{
			strDecimal = string.Format("{0:F" + n + "}", d);
		}
		else
		{
			int length = index;
			if (n != 0)
			{
				length = index + n + 1;
			}
			strDecimal = strDecimal.Substring(0, length);
		}
		return Decimal.Parse(strDecimal);
	}
</script>

<script>
    $(function () {
        checkInterval=setInterval("checkPayStatus();", 5000); 
    });
    function checkPayStatus() {
        $.ajax({
            type: "get", async: false, url: "/plus/pay/wx/checkstatus.aspx?orderid=<%=orderId%>&ordertype=<%=OrderType%>&anticache=" + Math.floor(Math.random() * 1000), cache: false, success: function (d) {
                if (d != '' && d.indexOf("success|") != -1) {
                    KesionJS.Alert('恭喜，支付成功!', "location.href ='"+ d.split('|')[1]+"';");
                }
            }
        });
    }
</script>
<style>
.wxtable tr td{ padding:5px 15px;}
.wxzfbox{width:221px;float:right;margin-top:55px;margin-right:160px;background:#fff;border-top:1px solid #e9e9e9;border:1px solid #e5e5e5;box-shadow: 0px 1px 10px #e5e9ed; padding:20px 40px; border-radius:10px;}
.wxzfbox .wxtit{ background:#0793e3;color:#fff; text-align:center; padding:10px 0px; font-size:14px; line-height:20px;}
.wxzfbox .wxinfo{ margin-top:10px;}
.wxzfbox .wxinfo .tips{ display:block; font-size:12px;color:#55ac36;}
.wxzfbox .wxinfo ul li{font-size:14px; padding:5px 0px 5px 75px; line-height:20px; position:relative;word-wrap:break-word;}
.wxzfbox .wxinfo ul li .button{width:100%;height:40px !important; line-height:100%; font-family:Microsoft Yahei;border-radius:3px; background:#51a6e6;color:#fff;border:0px;font-size:16px;border:0px;}
.wxzfbox .wxinfo ul li span{color:#999;width:75px;float:left; position:absolute;top:5px;left:0;}
</style>

<div style="width:100%;height:630px; background:#eee url(/sysimg/user/52d38974d25e2.jpg) no-repeat 35% -100px;">
	<div class="mainbox">
        <div class="wxzfbox">
        	<img src="/sysimg/user/wxzf.png" height="45" style="margin-bottom:15px;" />
        <img  style="width:209px;height:209px; background:url(../../user/img/codebg.png) no-repeat; padding:6px;"  src="/plus/chart.ashx?text=<%=MyCache.GetCacheConfig(5) %>/plus/pay/wx/send.aspx?orderid=<%=orderId %>%26flag=<%=flag %>%26uid=<%=new Kesion.Publics.TemporaryVar().UserID %>" />
             
            <div class="wxinfo">
            	<ul>
                	<li><span>订单编号：</span><%=orderId %></li>
                	<li><span>订单金额：</span><%=MyCache.GetCurrencySymbol %><%=realmoney.ToString()%><%=MyCache.GetCurrencyUnit %></li>
                	<li><span>实付金额：</span><strong style="font-size:20px;color:#ea4939"><%=MyCache.GetCurrencySymbol %><%=vmoney.ToString() %><%=MyCache.GetCurrencyUnit %></strong></li>
                    <%if (RateByUser==1) { %>
                    <li><span>&nbsp;</span><div class="tips">(手续费率<%=rate.ToString() %>%)</div></li>
                    <%} %>
                </ul>    
            </div>
           
        </div>
    </div>
</div>


<div style="clear:both"></div>